/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWMLABase;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

abstract class VWStepProcessorObject
extends VWMLABase
implements Serializable {
    private static final long serialVersionUID = 7444L;
    public static final int PROCESSOR_LAUNCH_DEFAULT = 1;
    public static final int PROCESSOR_STEP_DEFAULT = 2;
    public static final int PROCESSOR_DEFAULT = 3;
    public static final int PROCESSOR_LAUNCH = 4;
    public static final int PROCESSOR_STEP = 8;
    public static final int APP_TYPE_URL = 32;
    public static final int APP_TYPE_JAVA = 64;
    protected String m_name = null;
    protected Hashtable m_locations = null;
    protected int m_id = -1;
    protected int m_processorType = 0;
    protected int m_height = 600;
    protected int m_width = 800;
    protected String m_application = null;
    protected boolean m_bHasChanged = false;
    protected int m_defaultWebAppId = 0;
    protected int m_isolatedRegionWebAppId = 0;

    VWStepProcessorObject() {
    }

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 00:48:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    protected static String processorTypeToString(int processorType) throws VWException {
        String retVal = null;
        retVal = (processorType & 4) == 4 || (processorType & 1) == 1 ? "Launch" : ((processorType & 8) == 8 || (processorType & 2) == 2 ? "Step" : "");
        return retVal;
    }

    protected static String appTypeToString(int appType) throws VWException {
        String retVal = null;
        retVal = (appType & 0x20) == 32 ? "HTML" : ((appType & 0x40) == 64 ? "Java" : "");
        return retVal;
    }

    protected boolean equals(VWStepProcessorObject sp) {
        if (sp == null) {
            return false;
        }
        if (this.m_name == null ? sp.getName() != null : !this.m_name.equals(sp.getName())) {
            return false;
        }
        if (this.m_locations == null ? sp.getLocations() != null : !this.m_locations.equals(sp.getLocations())) {
            return false;
        }
        if (this.m_application == null ? sp.getApplicationName() != null : !this.m_application.equals(sp.getApplicationName())) {
            return false;
        }
        if (this.m_id != sp.getId()) {
            return false;
        }
        if (this.getProcessorType() != sp.getProcessorType()) {
            return false;
        }
        if (this.m_height != sp.getHeight()) {
            return false;
        }
        return this.m_width == sp.getWidth();
    }

    public int getId() {
        return this.m_id;
    }

    protected void setId(int id) {
        this.m_id = id;
    }

    protected void setDefaultWebAppId(int id) {
        this.m_defaultWebAppId = id;
    }

    protected void setIsolatedRegionWebAppId(int id) {
        this.m_isolatedRegionWebAppId = id;
    }

    public String getName() {
        return this.translateStr(this.m_name);
    }

    public String getLocation() {
        String result = null;
        if (this.m_locations != null) {
            try {
                if (this.m_locations.containsKey(new Integer(this.m_defaultWebAppId))) {
                    result = (String)this.m_locations.get(new Integer(this.m_defaultWebAppId));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Hashtable getLocations() {
        return this.m_locations;
    }

    public int getProcessorType() {
        int theType = 0;
        theType = (this.m_processorType & 1) == 1 ? 1 : ((this.m_processorType & 2) == 2 ? 2 : ((this.m_processorType & 4) == 4 ? 4 : 8));
        return theType;
    }

    protected int getProcessorFlags() {
        return this.m_processorType;
    }

    public int getAppType() {
        int theType = 0;
        theType = (this.m_processorType & 0x20) == 32 ? 32 : 64;
        return theType;
    }

    public boolean isDefaultType() {
        return (this.m_processorType & 3) > 0;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getWidth() {
        return this.m_width;
    }

    public String getApplicationName() {
        return this.m_application;
    }

    protected void setValue(int theId, int theProcessorType, String theName, int theAppType, Hashtable theLocations, int theWidth, int theHeight, String theApp) throws VWException {
        this.m_processorType = theProcessorType | theAppType;
        this.m_name = theName;
        this.m_locations = theLocations;
        this.m_width = theWidth;
        this.m_height = theHeight;
        this.m_application = theApp;
        this.m_id = theId;
    }

    protected void setValue(String theNewValue) throws VWException {
        if (theNewValue == null || theNewValue.trim().length() == 0) {
            return;
        }
        char delimiter = '\t';
        String DELIM = String.valueOf(delimiter);
        String token = null;
        StringTokenizer stmp = new StringTokenizer(theNewValue, DELIM, false);
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                this.m_id = new Integer(token);
            }
            catch (NumberFormatException e) {
                throw new VWException("vw.api.VWStepProcessordBadId", "Processor Id is not an integer : {0}: {1}.", token, new Integer(token.length()));
            }
        } else {
            throw new VWException("vw.api.VWStepProcessorMissingParts", "The step processor string is not valid.  Missing parts. {0}", theNewValue);
        }
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                this.m_processorType = new Integer(token);
            }
            catch (NumberFormatException e) {
                throw new VWException("vw.api.VWStepProcessordBadType", "Processor Type is not an integer : {0}: {1}", token, new Integer(token.length()));
            }
        } else {
            throw new VWException("vw.api.VWStepProcessorMissingParts", "The step processor string is invalid.  See Administrator to check that vwsteps.txt file is tab delimited {0}: {1}.", token, new Integer(token.length()));
        }
        if (!stmp.hasMoreTokens()) {
            throw new VWException("vw.api.VWStepProcessorMissingParts", "The step processor string is invalid.  See Administrator to check that vwsteps.txt file is tab delimited {0}: {1}.", token, new Integer(token.length()));
        }
        this.m_name = token = stmp.nextToken();
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            this.m_locations = new Hashtable(1);
            try {
                this.m_locations.put(new Integer(this.m_defaultWebAppId), token);
            }
            catch (Exception ex) {}
        } else {
            throw new VWException("vw.api.VWStepProcessorMissingParts", "The step processor string is invalid.  See Administrator to check that vwsteps.txt file is tab delimited {0}: {1}.", token, new Integer(token.length()));
        }
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                this.m_width = new Integer(token);
            }
            catch (NumberFormatException e) {
                throw new VWException("vw.api.VWStepProcessordBadWidth", "Width is not an integer : {0} : {1}", token, new Integer(token.length()));
            }
        } else {
            throw new VWException("vw.api.VWStepProcessorMissingParts", "The step processor string is not valid.  Missing parts.({0}:{1})", token, new Integer(token.length()));
        }
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                this.m_height = new Integer(token);
            }
            catch (NumberFormatException e) {
                throw new VWException("vw.api.VWStepProcessordBadHeight", "Height is not an integer : {0}: {1}", token, new Integer(token.length()));
            }
        } else {
            throw new VWException("vw.api.VWStepProcessorMissingParts", "The step processor string is not valid.  Missing parts.({0}: {1})", token, new Integer(token.length()));
        }
        if (stmp.hasMoreTokens()) {
            this.m_application = token = stmp.nextToken();
        }
    }

    protected Integer[] getLocationIds() {
        Integer[] result = null;
        if (this.m_locations != null) {
            Enumeration theKeys = this.m_locations.keys();
            Integer aKey = null;
            result = new Integer[this.m_locations.size()];
            for (int i = 0; i < this.m_locations.size(); ++i) {
                if (!theKeys.hasMoreElements()) continue;
                result[i] = aKey = (Integer)theKeys.nextElement();
            }
        }
        return result;
    }

    protected int getIsolatedRegionWebApp() throws VWException {
        return this.m_isolatedRegionWebAppId;
    }

    public void setHasChanged(boolean theNewValue) {
        this.m_bHasChanged = theNewValue;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public String toString() {
        char delimiter = '\t';
        String DELIM = String.valueOf(delimiter);
        String token = new Integer(this.m_id).toString();
        token = token + DELIM;
        token = token + new Integer(this.m_processorType).toString();
        token = token + DELIM;
        token = token + this.m_name;
        token = token + DELIM;
        token = token + this.getLocation();
        token = token + DELIM;
        token = token + new Integer(this.m_width).toString();
        token = token + DELIM;
        token = token + new Integer(this.m_height).toString();
        if (this.m_application != null) {
            token = token + DELIM;
            token = token + this.m_application;
        }
        return token;
    }
}

